<?php

// Backend type (kolab, carddav)
$config['kolab_addressbook_driver'] = "kolab";

// CalDAV server location (required when kolab_addressbook_driver = carddav)
$config['kolab_addressbook_carddav_server'] = "http://localhost";

// This option allows to set addressbooks priority or to disable some
// of them. Disabled addressbooks will be not shown in the UI. Default: 0.
// 0 - "Global address book(s) first". Use all address books, starting with the global (LDAP)
// 1 - "Personal address book(s) first". Use all address books, starting with the personal (Kolab)
// 2 - "Global address book(s) only". Use the global (LDAP) addressbook. Disable the personal.
// 3 - "Personal address book(s) only". Use the personal (Kolab) addressbook(s). Disable the global.
$config['kolab_addressbook_prio'] = 0;

// Base URL to build fully qualified URIs to access address books via CardDAV
// The following replacement variables are supported:
// %h - Current HTTP host
// %u - Current webmail user name
// %n - Folder name
// %i - Folder UUID
// For example: 'http://%h/iRony/addressbooks/%u/%i'
$config['kolab_addressbook_carddav_url'] = null;

// Name of LDAP addressbook (a key in ldap_public configuration array) for which
// the CardDAV URI will be displayed if kolab_addressbook_carddav_url is set.
// Use it when iRony's kolabdav_ldap_directory is enabled.
// Note: kolab_addressbook_carddav_url must use %i and not %n.
//
// WARNING: There's limitations with volume and performance:
// CardDAV does a full sync of the entire contact resource.
// For LDAP this means that all entries matching the base_dn/filter are synced to every client.
// It's thus only recommended for small setups with a couple hundred LDAP entries.
// Other than that, the ldap-directory exposed in iRony is strictly read-only.
// Although correctly stated in the CardDAV properties, some clients (e.g. the Thunderbird SoGO connector)
// ignore these properties and allow modifications which then result in sync errors because the server
// denies such updates.
$config['kolab_addressbook_carddav_ldap'] = '';
