<?php

class DataTest extends PHPUnit\Framework\TestCase
{
    /**
     * Test for kolab_sync_data::recurrence_to_kolab()
     */
    public function test_recurrence_to_kolab()
    {
        $xml = '<!DOCTYPE AirSync PUBLIC "-//AIRSYNC//DTD AirSync//EN" "http://www.microsoft.com/">
        <Sync xmlns="uri:AirSync" xmlns:AirSyncBase="uri:AirSyncBase" xmlns:Calendar="uri:Calendar">
        <ApplicationData>
                <Calendar:Recurrence>
                    <Calendar:Type>0</Calendar:Type>
                    <Calendar:Interval>1</Calendar:Interval>
                    <Calendar:Until>20101128T225959Z</Calendar:Until>
                </Calendar:Recurrence>
            </ApplicationData>
            </Sync>';

        $xml   = new SimpleXMLElement($xml);
        $event = new Syncroton_Model_Event($xml->ApplicationData);
        $data  = new kolab_sync_data_test();

        $result = $data->recurrence_to_kolab($event);

        $this->assertEquals('DAILY', $result['FREQ']);
        $this->assertEquals(1, $result['INTERVAL']);
        $this->assertEquals('20101128T225959Z', $result['UNTIL']->format("Ymd\THis\Z"));

        $xml = '<!DOCTYPE AirSync PUBLIC "-//AIRSYNC//DTD AirSync//EN" "http://www.microsoft.com/">
            <Sync xmlns="uri:AirSync" xmlns:AirSyncBase="uri:AirSyncBase" xmlns:Calendar="uri:Calendar">
            <ApplicationData>
                <Calendar:Recurrence>
                    <Calendar:Type>1</Calendar:Type>
                    <Calendar:Interval>1</Calendar:Interval>
                    <Calendar:DayOfWeek>8</Calendar:DayOfWeek>
                </Calendar:Recurrence>
            </ApplicationData>
            </Sync>';

        $xml   = new SimpleXMLElement($xml);
        $event = new Syncroton_Model_Event($xml->ApplicationData);

        $result = $data->recurrence_to_kolab($event, null);

        $this->assertEquals('WEEKLY', $result['FREQ']);
        $this->assertEquals(1, $result['INTERVAL']);
        $this->assertEquals('WE', $result['BYDAY']);
    }

    /**
     * Test for kolab_sync_data::recurrence_from_kolab()
     */
    public function test_recurrence_from_kolab()
    {
        $event = [
            'uid' => '52A09F6151F020312D99779F86838CF5-93BC4FC398A3FD52',
            '_type' => 'event',
            'priority' => 0,
            'attendees' => [
                [
                    'rsvp' => false,
                    'email' => 'bartek.machniak@nestle.kolab.ch',
                    'role' => 'ORGANIZER',
                    'status' => 'ACCEPTED',
                ],
                [
                    'name' => 'Machniak, Aleksander',
                    'status' => 'ACCEPTED',
                    'cutype' => 'INDIVIDUAL',
                    'rsvp' => false,
                    'email' => 'aleksander.machniak@nestle.kolab.ch',
                ],
            ],
            'created' => new DateTime('2023-10-20 09:49:26.000000'),
            'changed' => new DateTime('2023-10-20 09:49:34.000000'),
            'description' => 'description',
            'end' => new DateTime('2023-10-20 14:30:00.000000'),
            'start' => new DateTime('2023-10-20 14:00:00.000000'),
            'location' => '',
            'organizer' => [
                'rsvp' => false,
                'email' => 'bartek.machniak@nestle.kolab.ch',
                'role' => 'ORGANIZER',
                'status' => 'ACCEPTED',
            ],
            'sequence' => 0,
            'status' => 'CONFIRMED',
            'free_busy' => 'busy',
            'allday' => false,
            'recurrence' => [
                'FREQ' => 'WEEKLY',
                'INTERVAL' => '1',
            ],
        ];

        $data = new kolab_sync_data_test();

        $data->recurrence_from_kolab(null, $event, $result);

        $this->assertEquals($data::RECUR_TYPE_WEEKLY, $result['recurrence']->type);
        $this->assertEquals($data::RECUR_DOW_FRIDAY, $result['recurrence']->dayOfWeek);
        $this->assertEquals(1, $result['recurrence']->interval);

        $event['recurrence'] = [
            'FREQ' => 'MONTHLY',
            'BYMONTHDAY' => '2,15',
            'INTERVAL' => '5',
            'COUNT' => 3,
        ];

        $data->recurrence_from_kolab(null, $event, $result);

        $this->assertEquals($data::RECUR_TYPE_MONTHLY, $result['recurrence']->type);
        $this->assertEquals(2, $result['recurrence']->dayOfMonth);
        $this->assertEquals(5, $result['recurrence']->interval);
        $this->assertEquals(3, $result['recurrence']->occurrences);

        // TODO: More cases
    }
}

/**
 * kolab_sync_data wrapper, so we can test preotected methods too
 */
class kolab_sync_data_test extends kolab_sync_data
{
    public function __construct()
    {
    }

    public function recurrence_to_kolab($data, $dummy1 = null, $dummy2 = null)
    {
        return parent::recurrence_to_kolab($data, null);
    }

    public function recurrence_from_kolab($collection, $data, &$result, $type = 'Event')
    {
        return parent::recurrence_from_kolab($collection, $data, $result, $type);
    }

    public function toKolab($data, $folderId, $entry = null, $timezone = null)
    {
        return [];
    }

    public function getEntry(Syncroton_Model_SyncCollection $collection, $serverId, $as_array = false)
    {
        throw new Syncroton_Exception_NotFound("Not implemented");
    }
}
