<?php

namespace Tests\Sync;

class MeetingResponseTest extends \Tests\SyncTestCase
{
    /**
     * Test MeetingResponse command
     */
    public function testAcceptingInvitation()
    {
        $this->emptyTestFolder($davFolder = 'Calendar', 'event');
        $this->emptyTestFolder('INBOX', 'mail');

        $this->registerDevice();

        // Do the initial INBOX sync
        $folderId = '38b950ebd62cd9a66929c89615d0fc04'; // INBOX
        $syncKey = 0;
        $request = <<<EOF
            <?xml version="1.0" encoding="utf-8"?>
            <!DOCTYPE AirSync PUBLIC "-//AIRSYNC//DTD AirSync//EN" "http://www.microsoft.com/">
            <Sync xmlns="uri:AirSync">
                <Collections>
                    <Collection>
                        <SyncKey>{$syncKey}</SyncKey>
                        <CollectionId>{$folderId}</CollectionId>
                    </Collection>
                </Collections>
            </Sync>
            EOF;

        $response = $this->request($request, 'Sync');

        $this->assertEquals(200, $response->getStatusCode());

        $dom = $this->fromWbxml($response->getBody());
        $xpath = $this->xpath($dom);

        $this->assertSame('1', $xpath->query("//ns:Sync/ns:Collections/ns:Collection/ns:Status")->item(0)->nodeValue);
        $this->assertSame(strval(++$syncKey), $xpath->query("//ns:Sync/ns:Collections/ns:Collection/ns:SyncKey")->item(0)->nodeValue);

        // Append an invitation email, and sync it
        $sync = \kolab_sync::get_instance();
        $replace = [
            '$from' => 'test.test@domain.tld',
            '$to' => $sync->config->get('activesync_test_username'),
        ];
        $this->appendMail('INBOX', 'mail.itip1', $replace);

        $request = <<<EOF
            <?xml version="1.0" encoding="utf-8"?>
            <!DOCTYPE AirSync PUBLIC "-//AIRSYNC//DTD AirSync//EN" "http://www.microsoft.com/">
            <Sync xmlns="uri:AirSync">
                <Collections>
                    <Collection>
                        <SyncKey>{$syncKey}</SyncKey>
                        <CollectionId>{$folderId}</CollectionId>
                        <DeletesAsMoves>1</DeletesAsMoves>
                        <GetChanges>1</GetChanges>
                        <WindowSize>1</WindowSize>
                        <Options>
                            <FilterType>0</FilterType>
                            <Conflict>1</Conflict>
                            <BodyPreference xmlns="uri:AirSyncBase">
                                <Type>2</Type>
                                <TruncationSize>51200</TruncationSize>
                                <AllOrNone>0</AllOrNone>
                            </BodyPreference>
                        </Options>
                    </Collection>
                </Collections>
            </Sync>
            EOF;

        $response = $this->request($request, 'Sync');

        $this->assertEquals(200, $response->getStatusCode());

        $dom = $this->fromWbxml($response->getBody());
        $xpath = $this->xpath($dom);

        $root = $xpath->query("//ns:Sync/ns:Collections/ns:Collection")->item(0);
        $this->assertSame('1', $xpath->query("ns:Status", $root)->item(0)->nodeValue);
        $this->assertSame(strval(++$syncKey), $xpath->query("ns:SyncKey", $root)->item(0)->nodeValue);
        $this->assertSame(1, $xpath->query("ns:Commands/ns:Add", $root)->count());

        $serverId = $xpath->query("ns:Commands/ns:Add/ns:ServerId", $root)->item(0)->nodeValue;

        $root = $xpath->query("ns:Commands/ns:Add/ns:ApplicationData", $root)->item(0);
        $this->assertSame('You\'ve been invited to "Test"', $xpath->query("Email:Subject", $root)->item(0)->nodeValue);
        $this->assertSame('Organizer <test.test@domain.tld>', $xpath->query("Email:From", $root)->item(0)->nodeValue);
        $this->assertSame($replace['$to'], $xpath->query("Email:To", $root)->item(0)->nodeValue);
        $this->assertSame('0', $xpath->query("Email:Read", $root)->item(0)->nodeValue);
        $this->assertSame('IPM.Schedule.Meeting.Request', $xpath->query("Email:MessageClass", $root)->item(0)->nodeValue);
        $this->assertSame('urn:content-classes:calendarmessage', $xpath->query("Email:ContentClass", $root)->item(0)->nodeValue);
        $root = $xpath->query("Email:MeetingRequest", $root)->item(0);
        $this->assertSame('0', $xpath->query("Email:AllDayEvent", $root)->item(0)->nodeValue);
        $this->assertSame('2023-12-07T13:00:00.000Z', $xpath->query("Email:StartTime", $root)->item(0)->nodeValue);
        $this->assertSame('2023-12-07T13:30:00.000Z', $xpath->query("Email:EndTime", $root)->item(0)->nodeValue);
        $this->assertSame('test.test@domain.tld', $xpath->query("Email:Organizer", $root)->item(0)->nodeValue);
        $this->assertSame('1', $xpath->query("Email:ResponseRequested", $root)->item(0)->nodeValue);
        $this->assertSame('1', $xpath->query("Email:DisallowNewTimeProposal", $root)->item(0)->nodeValue);

        // Accept the invitation
        $request = <<<EOF
            <?xml version="1.0" encoding="utf-8"?>
            <!DOCTYPE AirSync PUBLIC "-//AIRSYNC//DTD AirSync//EN" "http://www.microsoft.com/">
            <MeetingResponse xmlns="uri:MeetingResponse" xmlns:Search="uri:Search">
                <Request>
                    <UserResponse>1</UserResponse>
                    <CollectionId>{$folderId}</CollectionId>
                    <RequestId>{$serverId}</RequestId>
                </Request>
            </MeetingResponse>
            EOF;

        $response = $this->request($request, 'MeetingResponse');

        $this->assertEquals(200, $response->getStatusCode());

        $dom = $this->fromWbxml($response->getBody());
        $xpath = $this->xpath($dom);
        $xpath->registerNamespace('MeetingResponse', 'uri:MeetingResponse');

        $root = $xpath->query("//MeetingResponse:MeetingResponse/MeetingResponse:Result")->item(0);
        $this->assertSame('1', $xpath->query("ns:Status", $root)->item(0)->nodeValue);
        $this->assertSame($serverId, $xpath->query("ns:RequestId", $root)->item(0)->nodeValue);
        $this->assertStringMatchesFormat("CRC%s", $xpath->query("ns:CalendarId", $root)->item(0)->nodeValue);
    }
}
