<?php

// The id of the LDAP address book (which refers to the $rcmail_config['ldap_public'])
// or complete addressbook definition array.
// --------------------------------------------------------------------
// Note: Multi-domain (hosted) installations can resolve domain aliases
//   by adding following settings in kolab_auth_addressbook spec.:
//
//   'domain_base_dn'   => 'cn=kolab,cn=config',
//   'domain_filter'    => '(&(objectclass=domainrelatedobject)(associateddomain=%s))',
//   'domain_name_attr' => 'associateddomain',
//
//   With this %dc variable in base_dn and groups/base_dn will be
//   replaced with DN string of resolved domain
//---------------------------------------------------------------------
$config['kolab_auth_addressbook'] = '';

// This will overwrite defined filter
$config['kolab_auth_filter'] = '(&(objectClass=kolabInetOrgPerson)(|(uid=%u)(mail=%fu)(alias=%fu)))';

// Use this field (from fieldmap configuration) to get authentication ID. Don't use an array here!
$config['kolab_auth_login'] = 'email';

// Use these fields (from fieldmap configuration) for default identity.
// If the value array contains more than one field, first non-empty will be used
// Note: These aren't LDAP attributes, but field names in config
// Note: If there's more than one email address, as many identities will be created
$config['kolab_auth_name']         = ['name', 'cn'];
$config['kolab_auth_email']        = ['email'];
$config['kolab_auth_organization'] = ['organization'];

// Role field (from fieldmap configuration)
$config['kolab_auth_role'] = 'role';

// Template for user names displayed in the UI.
// You can use all attributes from the 'fieldmap' property of the 'kolab_auth_addressbook' configuration
$config['kolab_auth_user_displayname'] = '{name} ({ou})';

// Login and password of the admin user. Enables "Login As" feature.
$config['kolab_auth_admin_login']    = '';
$config['kolab_auth_admin_password'] = '';

// Enable audit logging for abuse of administrative privileges.
$config['kolab_auth_auditlog'] = false;

// As set of rules to define the required rights on the target entry
// which allow an admin user to login as another user (the target).
// The effective rights value refers to either entry level attribute level rights:
//  * entry:[read|add|delete]
//  * attrib:<attribute-name>:[read|write|delete]
$config['kolab_auth_admin_rights'] = [
    // Roundcube task => required effective right
    'settings'        => 'entry:read',
    'mail'            => 'entry:delete',
    'addressbook'     => 'entry:delete',
    // or use a wildcard entry like this:
    '*'               => 'entry:read',
];

// Enable plugins on a role-by-role basis. In this example, the 'acl' plugin
// is enabled for people with a 'cn=professional-user,dc=mykolab,dc=ch' role.
//
// Note that this does NOT mean the 'acl' plugin is disabled for other people.
$config['kolab_auth_role_plugins'] = [
        'cn=professional-user,dc=mykolab,dc=ch' => [
                'acl',
            ],
    ];

// Settings on a role-by-role basis. In this example, the 'htmleditor' setting
// is enabled(1) for people with a 'cn=professional-user,dc=mykolab,dc=ch' role,
// and it cannot be overridden. Sample use-case: disable htmleditor for normal people,
// do not allow the setting to be controlled through the preferences, enable the
// html editor for professional users and allow them to override the setting in
// the preferences.
$config['kolab_auth_role_settings'] = [
        'cn=professional-user,dc=mykolab,dc=ch' => [
                'htmleditor' => [
                        'mode' => 'override',
                        'value' => 1,
                        'allow_override' => true,
                    ],
            ],
    ];

// List of LDAP addressbooks (keys of ldap_public configuration array)
// for which base_dn variables (%dc, etc.) will be replaced according to authenticated user DN
// Note: special name '*' for all LDAP addressbooks
$config['kolab_auth_ldap_addressbooks'] = ['*'];

// Enables storing/updating session tokens for free-busy token authentication
// See httpauth.allow_token option in Free-Busy service config.
// The option can be set to a number of seconds after which the token-session
// expires or to true (to get the configured Roundcube session time)
$config['freebusy_session_auth'] = null;
