<?php

class SettingsTest extends Tests\SyncTestCase
{
    /**
     * Test Settings command
     */
    public function testSettingsUserInformation()
    {
        // Test retrieving the settings
        $request = <<<EOF
            <?xml version="1.0" encoding="utf-8"?>
            <!DOCTYPE AirSync PUBLIC "-//AIRSYNC//DTD AirSync//EN" "http://www.microsoft.com/">
            <Settings xmlns="uri:Settings">
                <UserInformation>
                    <Get/>
                </UserInformation>
            </Settings>
            EOF;

        $response = $this->request($request, 'Settings');

        $this->assertEquals(200, $response->getStatusCode());

        $dom = self::fromWbxml($response->getBody());
        $xpath = $this->xpath($dom);

        $this->assertSame('1', $xpath->query("//ns:Settings/ns:Status")->item(0)->nodeValue);
        $this->assertSame('1', $xpath->query("//ns:Settings/ns:UserInformation/ns:Status")->item(0)->nodeValue);
        $this->assertSame(
            self::$username,
            $xpath->query("//ns:Settings/ns:UserInformation/ns:Get/ns:Accounts/ns:Account/ns:EmailAddresses/ns:PrimarySmtpAddress")->item(0)->nodeValue
        );
    }

    /**
     * Test Settings command
     */
    public function testSettingsDeviceInfomation()
    {
        // Test device info update
        $request = <<<EOF
            <?xml version="1.0" encoding="utf-8"?>
            <!DOCTYPE AirSync PUBLIC "-//AIRSYNC//DTD AirSync//EN" "http://www.microsoft.com/">
            <Settings xmlns="uri:Settings">
                <DeviceInformation>
                    <Set>
                        <Model>moto plus</Model>
                        <IMEI>111111111</IMEI>
                        <FriendlyName>fn</FriendlyName>
                        <OS>Android 10</OS>
                        <OSLanguage>English</OSLanguage>
                        <MobileOperator/>
                    </Set>
                </DeviceInformation>
            </Settings>
            EOF;

        $response = $this->request($request, 'Settings');

        $this->assertEquals(200, $response->getStatusCode());

        $dom = $this->fromWbxml($response->getBody());
        $xpath = $this->xpath($dom);

        $this->assertSame('1', $xpath->query("//ns:Settings/ns:Status")->item(0)->nodeValue);
        $this->assertSame('1', $xpath->query("//ns:Settings/ns:DeviceInformation/ns:Set/ns:Status")->item(0)->nodeValue);

        // TODO: Assert the properties have been set
    }

    /**
     * Test Settings command regarding OOF
     */
    public function testSettingsOOF()
    {
        // TODO: Test OOF settings
        $this->markTestIncomplete();
    }
}
