<?php

class SendMailTest extends Tests\SyncTestCase
{
    /**
     * Test SendMail command
     */
    public function testSendMail()
    {
        $this->emptyTestFolder('Sent', 'mail');

        $clientId = microtime();

        $request = <<<EOF
            <?xml version="1.0" encoding="utf-8"?>
            <!DOCTYPE AirSync PUBLIC "-//AIRSYNC//DTD AirSync//EN" "http://www.microsoft.com/">
            <SendMail xmlns="uri:ComposeMail">
                <ClientId>{$clientId}</ClientId>
                <SaveInSentItems />
                <Mime>From: testuser1@kolab.org
            To: testuser2@kolab.org
            Subject: Test
            MIME-Version: 1.0
            Content-Type: text/plain; charset="iso-8859-1"
            Message-ID: &lt;msg1@kolab.org&gt;
            X-Syncroton-Test: smtp=true

            This is the email body content.</Mime>
            </SendMail>
            EOF;

        $response = $this->request($request, 'SendMail');

        $this->assertEquals(200, $response->getStatusCode());
        $this->assertSame('', (string) $response->getBody());
        $emails = $this->listEmails('Sent', '*');
        $this->assertCount(1, $emails);
        // TODO: Assert mail content
    }

    /**
     * Test SendMail command
     */
    public function testSendMailErrorHandling()
    {
        $this->emptyTestFolder('Sent', 'mail');

        $clientId = microtime();

        $request = <<<EOF
            <?xml version="1.0" encoding="utf-8"?>
            <!DOCTYPE AirSync PUBLIC "-//AIRSYNC//DTD AirSync//EN" "http://www.microsoft.com/">
            <SendMail xmlns="uri:ComposeMail">
                <ClientId>{$clientId}</ClientId>
                <SaveInSentItems />
                <Mime>From: testuser1@kolab.org
            To: testuser2@kolab.org
            Subject: Test
            MIME-Version: 1.0
            Content-Type: text/plain; charset="iso-8859-1"
            Message-ID: &lt;msg1@kolab.org&gt;
            X-Syncroton-Test: smtp=false imap=true

            This is the email body content.</Mime>
            </SendMail>
            EOF;

        // Expect a SMTP error
        $response = $this->request($request, 'SendMail');

        $dom = $this->fromWbxml($response->getBody());
        $xpath = $this->xpath($dom);

        $this->assertEquals(200, $response->getStatusCode());
        $this->assertSame('120', $xpath->query("//ns:SendMail/ns:Status")->item(0)->nodeValue);
        $this->assertCount(0, $this->listEmails('Sent', '*'));

        // Test IMAP error handling
        $request = str_replace('smtp=false', 'smtp=true', $request);
        $request = str_replace('imap=true', 'imap=false', $request);

        $response = $this->request($request, 'SendMail');

        $dom = $this->fromWbxml($response->getBody());
        $xpath = $this->xpath($dom);

        $this->assertEquals(200, $response->getStatusCode());
        $this->assertSame('110', $xpath->query("//ns:SendMail/ns:Status")->item(0)->nodeValue);
        $this->assertCount(0, $this->listEmails('Sent', '*'));

        // Test no error
        // smtp=false would cause error, but the submission should get skipped now
        $request = str_replace('smtp=true', 'smtp=false', $request);
        $request = str_replace('imap=false', '', $request);

        $response = $this->request($request, 'SendMail');

        $this->assertEquals(200, $response->getStatusCode());
        $this->assertSame('', (string) $response->getBody());
        $this->assertCount(1, $this->listEmails('Sent', '*'));

        // Send the same mail again, expect an error
        $response = $this->request($request, 'SendMail');

        $dom = $this->fromWbxml($response->getBody());
        $xpath = $this->xpath($dom);

        $this->assertEquals(200, $response->getStatusCode());
        $this->assertSame('118', $xpath->query("//ns:SendMail/ns:Status")->item(0)->nodeValue);
        $this->assertCount(1, $this->listEmails('Sent', '*'));
    }
}
