<?php

class ItemOperationsTest extends Tests\SyncTestCase
{
    /**
     * Test ItemOperations::EmptyFolderContents request
     */
    public function testEmptyFolderContents()
    {
        $this->registerDevice();

        // TODO: Test invalid folder ID
        $collectionId = 'AAAAAAAAAAAA';
        $request = <<<EOF
            <?xml version="1.0" encoding="utf-8"?>
            <!DOCTYPE AirSync PUBLIC "-//AIRSYNC//DTD AirSync//EN" "http://www.microsoft.com/">
            <ItemOperations xmlns="uri:ItemOperations" xmlns:AirSync="uri:AirSync" xmlns:AirSyncBase="uri:AirSyncBase">
                <EmptyFolderContents>
                    <AirSync:CollectionId>{$collectionId}</AirSync:CollectionId>
                    <Options><DeleteSubFolders/></Options>
                </EmptyFolderContents>
            </ItemOperations>
            EOF;

        $response = $this->request($request, 'ItemOperations');

        $this->assertEquals(200, $response->getStatusCode());

        $dom = $this->fromWbxml($response->getBody());
        $xpath = $this->xpath($dom);

        $this->assertSame('1', $xpath->query("//ns:ItemOperations/ns:Status")->item(0)->nodeValue);
        $this->assertSame(
            strval(Syncroton_Exception_Status_ItemOperations::ITEM_SERVER_ERROR),
            $xpath->query("//ns:ItemOperations/ns:Response/ns:EmptyFolderContents/ns:Status")->item(0)->nodeValue
        );
        $this->assertSame(
            $collectionId,
            $xpath->query("//ns:ItemOperations/ns:Response/ns:EmptyFolderContents/AirSync:CollectionId")->item(0)->nodeValue
        );

        // Test Trash folder
        $collectionId = array_search('Trash', $this->folders);
        $this->assertIsString($collectionId);

        $request = <<<EOF
            <?xml version="1.0" encoding="utf-8"?>
            <!DOCTYPE AirSync PUBLIC "-//AIRSYNC//DTD AirSync//EN" "http://www.microsoft.com/">
            <ItemOperations xmlns="uri:ItemOperations" xmlns:AirSync="uri:AirSync" xmlns:AirSyncBase="uri:AirSyncBase">
                <EmptyFolderContents>
                    <AirSync:CollectionId>{$collectionId}</AirSync:CollectionId>
                    <Options><DeleteSubFolders/></Options>
                </EmptyFolderContents>
            </ItemOperations>
            EOF;

        $response = $this->request($request, 'ItemOperations');

        $this->assertEquals(200, $response->getStatusCode());

        $dom = $this->fromWbxml($response->getBody());
        $xpath = $this->xpath($dom);

        $this->assertSame('1', $xpath->query("//ns:ItemOperations/ns:Status")->item(0)->nodeValue);
        $this->assertSame('1', $xpath->query("//ns:ItemOperations/ns:Response/ns:EmptyFolderContents/ns:Status")->item(0)->nodeValue);
        $this->assertSame($collectionId, $xpath->query("//ns:ItemOperations/ns:Response/ns:EmptyFolderContents/AirSync:CollectionId")->item(0)->nodeValue);

        // TODO: Test DAV folder
        // TODO: Test a folder with subfolders
        // TODO: Test non-empty folder and assert that all objects are gone
        $this->markTestIncomplete();
    }

    /**
     * Test ItemOperations::Fetch request
     */
    public function testFetch()
    {
        $this->markTestIncomplete();
    }
}
