<?php

/*
 +--------------------------------------------------------------------------+
 | Kolab Sync (ActiveSync for Kolab)                                        |
 |                                                                          |
 | Copyright (C) 2011-2014, Kolab Systems AG <contact@kolabsys.com>         |
 |                                                                          |
 | This program is free software: you can redistribute it and/or modify     |
 | it under the terms of the GNU Affero General Public License as published |
 | by the Free Software Foundation, either version 3 of the License, or     |
 | (at your option) any later version.                                      |
 |                                                                          |
 | This program is distributed in the hope that it will be useful,          |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of           |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the             |
 | GNU Affero General Public License for more details.                      |
 |                                                                          |
 | You should have received a copy of the GNU Affero General Public License |
 | along with this program. If not, see <http://www.gnu.org/licenses/>      |
 +--------------------------------------------------------------------------+
 | Author: Aleksander Machniak <machniak@kolabsys.com>                      |
 +--------------------------------------------------------------------------+
*/

/**
 * Notes data class for Syncroton
 */
class kolab_sync_data_notes extends kolab_sync_data
{
    /**
     * Mapping from ActiveSync Calendar namespace fields
     */
    protected $mapping = [
        'body'             => 'description',
        'categories'       => 'categories',
        'lastModifiedDate' => 'changed',
        //'messageClass'     => 'messageClass',
        'subject'          => 'title',
    ];

    /**
     * Kolab object type
     *
     * @var string
     */
    protected $modelName = 'note';

    /**
     * Type of the default folder
     *
     * @var int
     */
    protected $defaultFolderType = Syncroton_Command_FolderSync::FOLDERTYPE_NOTE;

    /**
     * Default container for new entries
     *
     * @var string
     */
    protected $defaultFolder = 'Notes';

    /**
     * Type of user created folders
     *
     * @var int
     */
    protected $folderType = Syncroton_Command_FolderSync::FOLDERTYPE_NOTE_USER_CREATED;


    /**
     * Appends note data to xml element
     *
     * @param Syncroton_Model_SyncCollection $collection Collection data
     * @param string                         $serverId   Local entry identifier
     * @param boolean                        $as_array   Return entry as an array
     *
     * @return array|Syncroton_Model_Note|array Note object
     */
    public function getEntry(Syncroton_Model_SyncCollection $collection, $serverId, $as_array = false)
    {
        $note   = is_array($serverId) ? $serverId : $this->getObject($collection->collectionId, $serverId);
        $result = [];

        // Calendar namespace fields
        foreach ($this->mapping as $key => $name) {
            $value = $this->getKolabDataItem($note, $name);

            switch ($name) {
                case 'changed':
                    $value = self::date_from_kolab($value);
                    break;

                case 'description':
                    $value = $this->body_from_kolab($value, $collection);
                    break;
            }

            if (empty($value) || is_array($value)) {
                continue;
            }

            $result[$key] = $value;
        }

        $result['messageClass'] = 'IPM.StickyNote';

        return $as_array ? $result : new Syncroton_Model_Note($result);
    }

    /**
     * convert note from xml to libkolab array
     *
     * @param Syncroton_Model_Note $data     Note to convert
     * @param string               $folderid Folder identifier
     * @param array                $entry    Existing entry
     *
     * @return array
     */
    public function toKolab($data, $folderid, $entry = null)
    {
        $note = !empty($entry) ? $entry : [];

        // Calendar namespace fields
        foreach ($this->mapping as $key => $name) {
            $value = $data->$key;

            switch ($name) {
                case 'description':
                    $supported_body_types = [
                        Syncroton_Model_EmailBody::TYPE_HTML,
                        Syncroton_Model_EmailBody::TYPE_PLAINTEXT,
                    ];
                    $value = $this->getBody($value, $supported_body_types);

                    // If description isn't specified keep old description
                    if ($value === null) {
                        continue 2;
                    }
                    break;
            }

            $this->setKolabDataItem($note, $name, $value);
        }

        return $note;
    }
}
