<?php

declare(strict_types=1);

use PhpCsFixer\Config;
use PhpCsFixer\Finder;

$finder = Finder::create()
    ->in([__DIR__])
    ->exclude([
        'lib/ext/Roundcube',
        'lib/plugins',
        'vendor',
    ])
    ->ignoreDotFiles(false)
    ->name('*.php.dist');

return (new Config())
    ->setRiskyAllowed(true)
    ->setRules([
        '@PHP7x4Migration' => true,
        '@PHP7x4Migration:risky' => true,
        '@PHP8x0Migration' => true,
        '@PSR1' => true,
        '@PSR12' => true,

        'concat_space' => [
            'spacing' => 'one',
        ],

        'declare_strict_types' => false,
        'phpdoc_add_missing_param_annotation' => false,
        'use_arrow_functions' => false,
        'void_return' => false,

        'yoda_style' => [
            'equal' => false,
            'identical' => false,
        ],

        // TODO - risky
        'no_unset_on_property' => false,
        'random_api_migration' => false,
        'strict_param' => false,
    ])
    ->setFinder($finder)
    ->setCacheFile(sys_get_temp_dir() . '/php-cs-fixer.' . md5(__DIR__) . '.cache');
