<?php

/**
 * Syncroton
 *
 * @package     Syncroton
 * @subpackage  Model
 * @license     http://www.tine20.org/licenses/lgpl.html LGPL Version 3
 * @copyright   Copyright (c) 2012-2014 Kolab Systems AG
 * @author      Aleksander Machniak <machniak@kolabsys.com>
 */

/**
 * Class to handle ActiveSync Search/Response/Store element
 *
 * @package    Syncroton
 * @subpackage Model
 *
 * @property  int     $status
 * @property  array   $result
 * @property  array   $range
 * @property  int     $total
 */
class Syncroton_Model_StoreResponse extends Syncroton_Model_AXMLEntry
{
    /**
     * status constants
     */
    public const STATUS_SUCCESS            = 1;
    public const STATUS_INVALIDREQUEST     = 2;
    public const STATUS_SERVERERROR        = 3;
    public const STATUS_BADLINK            = 4;
    public const STATUS_ACCESSDENIED       = 5;
    public const STATUS_NOTFOUND           = 6;
    public const STATUS_CONNECTIONFAILED   = 7;
    public const STATUS_TOOCOMPLEX         = 8;
    public const STATUS_TIMEDOUT           = 10;
    public const STATUS_FOLDERSYNCREQUIRED = 11;
    public const STATUS_ENDOFRANGE         = 12;
    public const STATUS_ACCESSBLOCKED      = 13;
    public const STATUS_CREDENTIALSREQUIRED = 14;

    protected $_xmlBaseElement = 'Store';

    protected $_properties = [
        'Search' => [
            'status'    => ['type' => 'number'],
            'result'    => ['type' => 'container', 'multiple' => true],
            'range'     => ['type' => 'string'],
            'total'     => ['type' => 'number'],
        ],
    ];

    /**
     * (non-PHPdoc)
     * @see Syncroton_Model_AXMLEntry::appendXML()
     */
    public function appendXML(DOMElement $_domParrent, Syncroton_Model_IDevice $device)
    {
        $this->_addXMLNamespaces($_domParrent);

        foreach ($this->_elements as $elementName => $value) {
            // skip empty values
            if ($value === null || $value === '') {
                continue;
            }

            [$nameSpace, $elementProperties] = $this->_getElementProperties($elementName);

            $nameSpace = 'uri:' . $nameSpace;

            switch ($elementName) {
                case 'result':
                    foreach ($value as $result) {
                        $element = $_domParrent->ownerDocument->createElementNS($nameSpace, 'Result');
                        $result->appendXML($element, $device);
                        $_domParrent->appendChild($element);
                    }
                    break;

                case 'range':
                    if (is_array($value) && count($value) == 2) {
                        $value = implode('-', $value);
                    }

                    // no break
                default:
                    $element = $_domParrent->ownerDocument->createElementNS($nameSpace, ucfirst($elementName));
                    $element->appendChild($_domParrent->ownerDocument->createTextNode($value));
                    $_domParrent->appendChild($element);
            }
        }
    }
}
