<?php

/**
 * Syncroton
 *
 * @package     Syncroton
 * @subpackage  Model
 * @license     http://www.tine20.org/licenses/lgpl.html LGPL Version 3
 * @copyright   Copyright (c) 2012-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 * @author      Lars Kneschke <l.kneschke@metaways.de>
 */

/**
 * class to handle Email::Recurrence
 *
 * @package     Syncroton
 * @subpackage  Model
 * @property    int       $calendarType
 * @property    int       $dayOfMonth
 * @property    int       $dayOfWeek
 * @property    int       $firstDayOfWeek
 * @property    int       $interval
 * @property    int       $isLeapMonth
 * @property    int       $monthOfYear
 * @property    int       $occurrences
 * @property    int       $type
 * @property    DateTime  $until
 * @property    int       $weekOfMonth
 */
class Syncroton_Model_EmailRecurrence extends Syncroton_Model_AXMLEntry
{
    protected $_xmlBaseElement = 'Recurrence';

    /**
     * recur types
     */
    public const TYPE_DAILY          = 0;     // Recurs daily
    public const TYPE_WEEKLY         = 1;     // Recurs weekly
    public const TYPE_MONTHLY        = 3;     // Recurs monthly
    public const TYPE_MONTHLY_DAYN   = 2;     // Recurs monthly on the nth day
    public const TYPE_YEARLY         = 5;     // Recurs yearly on the nth day of the nth month each year
    public const TYPE_YEARLY_DAYN    = 6;     // Recurs yearly on the nth day of the week of the nth month

    /**
     * day of week constants
     */
    public const RECUR_DOW_SUNDAY      = 1;
    public const RECUR_DOW_MONDAY      = 2;
    public const RECUR_DOW_TUESDAY     = 4;
    public const RECUR_DOW_WEDNESDAY   = 8;
    public const RECUR_DOW_THURSDAY    = 16;
    public const RECUR_DOW_FRIDAY      = 32;
    public const RECUR_DOW_SATURDAY    = 64;

    protected $_dateTimeFormat = "Ymd\THis\Z";

    protected $_properties = [
        'Email' => [
            'dayOfMonth'     => ['type' => 'number'],
            'dayOfWeek'      => ['type' => 'number'],
            'interval'       => ['type' => 'number'], // 1 or 2
            'monthOfYear'    => ['type' => 'number'],
            'occurrences'    => ['type' => 'number'],
            'type'           => ['type' => 'number'],
            'until'          => ['type' => 'datetime'],
            'weekOfMonth'    => ['type' => 'number'],
        ],
        'Email2' => [
            'calendarType'   => ['type' => 'number'],
            'firstDayOfWeek' => ['type' => 'number'],
            'isLeapMonth'    => ['type' => 'number'],
        ],
    ];
}
