<?php

// The id of the LDAP address book (which refers to the $rcmail_config['ldap_public'])
// or complete addressbook definition array.
// --------------------------------------------------------------------
// Note: Multi-domain (hosted) installations can resolve domain aliases
//   by adding following settings in kolab_auth_addressbook spec.:
//
//   'domain_base_dn'   => 'cn=kolab,cn=config',
//   'domain_filter'    => '(&(objectclass=domainrelatedobject)(associateddomain=%s))',
//   'domain_name_attr' => 'associateddomain',
//
//   With this %dc variable in base_dn and groups/base_dn will be
//   replaced with DN string of resolved domain
//---------------------------------------------------------------------
// When empty, defaults to kolab_auth_addressbook.
$config['kolab_delegation_addressbook'] = '';

// This will overwrite defined LDAP filter
// Note: LDAP addressbook defined for kolab_auth plugin is used
$config['kolab_delegation_filter'] = '(|(objectClass=kolabInetOrgPerson)(&(objectclass=kolabsharedfolder)(kolabFolderType=mail)))';

// Delegates field (from fieldmap configuration) to get delegates list
// Note: This is a field name, not LDAP attribute name
// Note: LDAP addressbook defined for kolab_auth plugin is used
$config['kolab_delegation_delegate_field'] = 'kolabDelegate';

// User authentication ID field (from fieldmap configuration)
// See kolab_auth plugin config
$config['kolab_delegation_login_field'] = 'email';

// Use this fields (from fieldmap configuration) for identities
// If the value array contains more than one field, first non-empty will be used
// Note: These are not LDAP attributes, but field names in config
// Note: If there are more than one email address, as many identities will be created
// See kolab_auth plugin config
$config['kolab_delegation_name_field']         = ['name', 'cn'];
$config['kolab_delegation_email_field']        = ['email'];
$config['kolab_delegation_organization_field'] = ['organization'];

// Remove all user identities which do not match the user's primary or alias
// addresses and delegator's addresses
$config['kolab_delegation_purge_identities'] = false;
