<?php

class BodyConverterTest extends PHPUnit\Framework\TestCase
{
    public static function data_html_to_text()
    {
        return [
            ['', ''],
            ['<div></div>', ''],
            ['<div>a</div>', 'a'],
            ['<html><head><title>title</title></head></html>', ''],
        ];
    }

    /**
     * @dataProvider data_html_to_text
     */
    public function test_html_to_text($html, $text)
    {
        $converter = new kolab_sync_body_converter($html, Syncroton_Model_EmailBody::TYPE_HTML);
        $output    = $converter->convert(Syncroton_Model_EmailBody::TYPE_PLAINTEXT);

        $this->assertEquals(trim($text), trim($output));
    }

    /**
     * Test RTF convertion to HTML and Plain text
     */
    public function test_rtf_to_text()
    {
        $rtf = file_get_contents(__DIR__ . '/../src/sample.rtf');

        $converter = new kolab_sync_body_converter($rtf, Syncroton_Model_EmailBody::TYPE_RTF);

        $output = $converter->convert(Syncroton_Model_EmailBody::TYPE_PLAINTEXT);
        $this->assertStringContainsString('This is text', trim($output));

        $output = $converter->convert(Syncroton_Model_EmailBody::TYPE_HTML);
        $this->assertStringContainsString('<span style="font-family:Helvetica,sans-serif;color:#0000ff;">anchor</span>', trim($output));
    }
}
