<?php

class ProvisionTest extends Tests\SyncTestCase
{
    /**
     * Test Provision command
     */
    public function testProvision()
    {
        $request = <<<EOF
            <?xml version="1.0" encoding="utf-8"?>
            <!DOCTYPE AirSync PUBLIC "-//AIRSYNC//DTD AirSync//EN" "http://www.microsoft.com/">
            <Provision xmlns="uri:Provision" xmlns:Settings="uri:Settings">
                <DeviceInformation xmlns="uri:Settings">
                    <Set>
                        <Model>moto e(6) plus</Model>
                        <IMEI>000000000000000</IMEI>
                        <FriendlyName>pokerp_reteu_64</FriendlyName>
                        <OS>Android 9.58-8</OS>
                        <OSLanguage>Polish (Poland)</OSLanguage>
                        <MobileOperator/>
                    </Set>
                </DeviceInformation>
                <Policies>
                    <Policy>
                        <PolicyType>MS-EAS-Provisioning-WBXML</PolicyType>
                    </Policy>
                </Policies>
            </Provision>
            EOF;

        $response = $this->request($request, 'Provision');

        $this->assertEquals(200, $response->getStatusCode());

        $dom = $this->fromWbxml($response->getBody());
        $xpath = $this->xpath($dom);

        $this->assertSame('1', $xpath->query("//ns:Provision/ns:Status")->item(0)->nodeValue);
        $this->assertSame('1', $xpath->query("//ns:Provision/Settings:DeviceInformation/Settings:Status")->item(0)->nodeValue);
        $this->assertSame('2', $xpath->query("//ns:Provision/ns:Policies/ns:Policy/ns:Status")->item(0)->nodeValue);

        // TODO: Assert the properties have been set
    }
}
