<?php

/**
 * Syncroton
 *
 * @package     Syncroton
 * @subpackage  Model
 * @license     http://www.tine20.org/licenses/lgpl.html LGPL Version 3
 * @copyright   Copyright (c) 2012-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 * @author      Lars Kneschke <l.kneschke@metaways.de>
 */

/**
 * class to handle ActiveSync event
 *
 * @package     Syncroton
 * @subpackage  Model
 * @property    string   $contentType
 * @property    string   $data
 * @property    int      $part
 */
class Syncroton_Model_FileReference extends Syncroton_Model_AXMLEntry
{
    protected $_xmlBaseElement = 'ApplicationData';

    protected $_properties = [
        'AirSyncBase' => [
            'contentType' => ['type' => 'string'],
        ],
        'ItemOperations' => [
            'data'        => ['type' => 'string', 'encoding' => 'base64'],
            'part'        => ['type' => 'number'],
        ],
    ];

    /**
     *
     * @param SimpleXMLElement $properties
     * @throws InvalidArgumentException
     */
    public function setFromSimpleXMLElement(SimpleXMLElement $properties)
    {
        // do nothing
        return;
    }
}
