<?php

/**
 * Syncroton
 *
 * @package     Syncroton
 * @subpackage  Command
 * @license     http://www.tine20.org/licenses/lgpl.html LGPL Version 3
 * @copyright   Copyright (c) 2009-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 * @copyright   Copyright (c) 2012-2012 Kolab Systems AG (http://www.kolabsys.com)
 * @author      Lars Kneschke <l.kneschke@metaways.de>
 * @author      Aleksander Machniak <machniak@kolabsys.com>
 */

/**
 * class to handle ActiveSync MoveItems command
 *
 * @package     Syncroton
 * @subpackage  Command
 */
class Syncroton_Command_MoveItems extends Syncroton_Command_Wbxml
{
    public const STATUS_SUCCESS                = 3;

    protected $_defaultNameSpace    = 'uri:Move';
    protected $_documentElement     = 'MoveItems';

    /**
     * list of items to move
     *
     * @var array
     */
    protected $_moves = [];

    /**
     * parse MoveItems request
     */
    public function handle()
    {
        $xml = simplexml_import_dom($this->_requestBody);

        foreach ($xml->Move as $move) {
            $this->_moves[] = [
                'srcMsgId' => (string)$move->SrcMsgId,
                'srcFldId' => (string)$move->SrcFldId,
                'dstFldId' => (string)$move->DstFldId,
            ];
        }
    }

    /**
     * generate MoveItems response
     */
    public function getResponse()
    {
        $moves = $this->_outputDom->documentElement;

        foreach ($this->_moves as $move) {
            $response = $moves->appendChild($this->_outputDom->createElementNS('uri:Move', 'Response'));
            $response->appendChild($this->_outputDom->createElementNS('uri:Move', 'SrcMsgId', $move['srcMsgId']));

            if ($this->_logger instanceof Zend_Log) {
                $this->_logger->info(__METHOD__ . '::' . __LINE__ . " Moving from " . $move['srcFldId'] . " to " . $move['dstFldId']);
            }

            try {
                try {
                    $sourceFolder = $this->_folderBackend->getFolder($this->_device, $move['srcFldId']);
                } catch (Syncroton_Exception_NotFound $e) {
                    throw new Syncroton_Exception_Status_MoveItems(Syncroton_Exception_Status_MoveItems::INVALID_SOURCE);
                }

                try {
                    $destinationFolder = $this->_folderBackend->getFolder($this->_device, $move['dstFldId']);
                } catch (Syncroton_Exception_NotFound $senf) {
                    throw new Syncroton_Exception_Status_MoveItems(Syncroton_Exception_Status_MoveItems::INVALID_DESTINATION);
                }

                if ($move['srcFldId'] === $move['dstFldId']) {
                    throw new Syncroton_Exception_Status_MoveItems(Syncroton_Exception_Status_MoveItems::SAME_FOLDER);
                }

                $dataController = Syncroton_Data_Factory::factory($sourceFolder->class, $this->_device, $this->_syncTimeStamp);
                $newId          = $dataController->moveItem($move['srcFldId'], $move['srcMsgId'], $move['dstFldId']);
                if (!$newId) {
                    // We don't actually know what the reason was that this failed, but from the resolution description this error seems to make the most sense,
                    // and we rule out most other reasons before.
                    throw new Syncroton_Exception_Status_MoveItems(Syncroton_Exception_Status_MoveItems::INVALID_SOURCE);
                }

                $response->appendChild($this->_outputDom->createElementNS('uri:Move', 'Status', Syncroton_Command_MoveItems::STATUS_SUCCESS));
                $response->appendChild($this->_outputDom->createElementNS('uri:Move', 'DstMsgId', $newId));
            } catch (Syncroton_Exception_Status_MoveItems $e) {
                if ($this->_logger instanceof Zend_Log) {
                    $this->_logger->warn(__METHOD__ . '::' . __LINE__ . " Move failed: " . $e->getMessage());
                }
                $response->appendChild($this->_outputDom->createElementNS('uri:Move', 'Status', $e->getCode()));
            } catch (Exception $e) {
                if ($this->_logger instanceof Zend_Log) {
                    $this->_logger->warn(__METHOD__ . '::' . __LINE__ . " Move failed: " . $e->getMessage());
                }
                $response->appendChild($this->_outputDom->createElementNS('uri:Move', 'Status', Syncroton_Exception_Status_MoveItems::FOLDER_LOCKED));
            }
        }

        return $this->_outputDom;
    }
}
