#!/usr/bin/php
<?php

/*
 +--------------------------------------------------------------------------+
 | Kolab Sync (ActiveSync for Kolab)                                        |
 |                                                                          |
 | Copyright (C) 2024, Apheleia IT AG <contact@apheleia-it.ch>              |
 |                                                                          |
 | This program is free software: you can redistribute it and/or modify     |
 | it under the terms of the GNU Affero General Public License as published |
 | by the Free Software Foundation, either version 3 of the License, or     |
 | (at your option) any later version.                                      |
 |                                                                          |
 | This program is distributed in the hope that it will be useful,          |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of           |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the             |
 | GNU Affero General Public License for more details.                      |
 |                                                                          |
 | You should have received a copy of the GNU Affero General Public License |
 | along with this program. If not, see <http://www.gnu.org/licenses/>      |
 +--------------------------------------------------------------------------+
 | Author: Aleksander Machniak <machniak@apheleia-it.ch>                    |
 +--------------------------------------------------------------------------+
*/

require_once 'shared.php';

$opts = rcube_utils::get_opt([
    'o' => 'owner',
    'f' => 'folder',
    'd' => 'deviceid',
    't' => 'devicetype', // e.g. WindowsOutlook15 or iPhone
]);

if (empty($opts['owner'])) {
    \rcube::raise_error("Owner not specified (--owner).", false, true);
}

$cli = new SyncrotonCli();
$userid = $cli->selectUser($opts['owner']);
$devices = $cli->selectDevices($opts['deviceid'] ?? null, $opts['devicetype'] ?? null);
$db = $cli->db;

if (empty($devices)) {
    rcube::raise_error("Device not found.", false, true);
}

// TODO: Support not only top-level folders

$select = $db->query(
    "SELECT syncroton_folder.id, `displayname`, `folderid`, `deviceid` FROM `syncroton_folder`"
    . " JOIN `syncroton_device` ON syncroton_device.id = syncroton_folder.device_id"
    . " WHERE `device_id` IN (" . $db->array2list($devices) . ")"
    . " AND `parentid` = '0' AND `displayname` = " . $db->quote($opts['folder'])
);

while ($record = $db->fetch_assoc($select)) {
    if (!empty($opts['dry-run'])) {
        print("[DRY-RUN] {$record['displayname']} {$record['deviceid']} ({$record['id']}:{$record['folderid']})\n");
    } else {
        $db->query("UPDATE `syncroton_folder` SET `resync` = 1 WHERE id = ?", $record['id']);
        print("{$record['displayname']} {$record['deviceid']} ({$record['id']}:{$record['folderid']})\n");
    }
}
