<?php

class DataEmailTest extends PHPUnit\Framework\TestCase
{
    /**
     * Test GlobalObjId encoding/decoding
     */
    public function test_globalobjid()
    {
        // https://learn.microsoft.com/en-us/openspecs/exchange_server_protocols/ms-asemail/e7424ddc-dd10-431e-a0b7-5c794863370e
        $input = 'BAAAAIIA4AB0xbcQGoLgCAAAAAAAAAAAAAAAAAAAAAAAAAAAMwAAAHZDYWwtVWlkAQAAAHs4MTQxMkQzQy0yQTI0LTRFOUQtQjIwRS0xMUY3QkJFOTI3OTl9AA==';
        $output = kolab_sync_data_email::decodeGlobalObjId($input);

        $this->assertSame(51, $output['bytecount']);
        $this->assertSame('{81412D3C-2A24-4E9D-B20E-11F7BBE92799}', $output['uid']);

        $encoded = kolab_sync_data_email::encodeGlobalObjId($output);
        $this->assertSame($encoded, $input);

        $input = 'BAAAAIIA4AB0xbcQGoLgCAfUCRDgQMnBJoXEAQAAAAAAAAAAEAAAAAvw7UtuTulOnjnjhns3jvM=';
        $output = kolab_sync_data_email::decodeGlobalObjId($input);

        $this->assertSame(16, $output['bytecount']);
        $this->assertSame(2004, $output['year']);
        $this->assertSame(9, $output['month']);
        $this->assertSame(16, $output['day']);
        $this->assertSame(127373090979660000, $output['now']);

        // This is how the "now" value is interpreted
        // $winSecs       = (int)($output['now'] / 10000000); // convert microseconds to seconds
        // $unixTimestamp = ($winSecs - 11644473600); // subtract 1.1.1600 - 1.1.1970 difference in seconds
        // print(date(DateTime::RFC822, $unixTimestamp));

        $encoded = kolab_sync_data_email::encodeGlobalObjId($output);
        $this->assertSame($encoded, $input);
    }
}
