<?php

class DataCalendarTest extends PHPUnit\Framework\TestCase
{
    /**
     * Test for kolab_sync_data_calendar::from_kolab_alarm()
     */
    public function test_from_kolab_alarm()
    {
        $obj = new kolab_sync_data_calendar_test();

        $result = $obj->from_kolab_alarm([]);
        $this->assertSame(null, $result);

        $event  = ['valarms' => [[
            'action'  => 'DISPLAY',
            'trigger' => 'PT5M',
        ]]];
        $result = $obj->from_kolab_alarm($event);
        $this->assertSame(null, $result);

        $event  = ['valarms' => [[
            'action'  => 'DISPLAY',
            'trigger' => '-PT5M',
        ]]];
        $result = $obj->from_kolab_alarm($event);
        $this->assertSame(5, $result);

        $event  = ['valarms' => [[
            'action'  => 'DISPLAY',
            'trigger' => 'PT0M',
        ]]];
        $result = $obj->from_kolab_alarm($event);
        $this->assertSame(0, $result);

        $event  = ['valarms' => [[
            'action'  => 'DISPLAY',
            'trigger' => '-PT0M',
        ]]];
        $result = $obj->from_kolab_alarm($event);
        $this->assertSame(0, $result);

        $event  = ['valarms' => [[
            'action'  => 'DISPLAY',
            'trigger' => 'PT0S',
        ]]];
        $result = $obj->from_kolab_alarm($event);
        $this->assertSame(0, $result);

        // alarms on specified DateTime (T2420)

        $event = [
            // no start datetime defined
            'valarms' => [
                [
                    'action'  => 'DISPLAY',
                    'trigger' => new DateTime('now + 1 hour'),
                ],
            ],
        ];
        $result = $obj->from_kolab_alarm($event);
        $this->assertSame(null, $result);

        $event = [
            'start'   => new DateTime('now + 10 minutes'),
            'valarms' => [
                [
                   'action'  => 'DISPLAY',
                    'trigger' => new DateTime('now + 1 hour'),
                ],
            ],
        ];
        $result = $obj->from_kolab_alarm($event);
        $this->assertSame(null, $result);

        $event = [
            'start'   => new DateTime('now + 60 minutes'),
            'valarms' => [
                [
                    'action'  => 'DISPLAY',
                    'trigger' => new DateTime('now + 50 minutes'),
                ],
            ],
        ];
        $result = $obj->from_kolab_alarm($event);
        $this->assertSame(10, $result);
    }

    /**
     * Test for kolab_sync_data_calendar::to_kolab_alarm()
     */
    public function test_to_kolab_alarm()
    {
        $obj = new kolab_sync_data_calendar_test();

        $result = $obj->to_kolab_alarm(null, []);
        $this->assertSame([], $result);

        $result = $obj->to_kolab_alarm(0, []);
        $this->assertSame('-PT0M', $result[0]['trigger']);

        $result = $obj->to_kolab_alarm(15, []);
        $this->assertSame('-PT15M', $result[0]['trigger']);
        $this->assertSame('DISPLAY', $result[0]['action']);
    }
}

/**
 * kolab_sync_data_calendar wrapper, so we can test protected methods too
 */
class kolab_sync_data_calendar_test extends kolab_sync_data_calendar
{
    public function __construct()
    {
    }

    public function from_kolab_alarm($value)
    {
        return parent::from_kolab_alarm($value);
    }

    public function to_kolab_alarm($value, $event)
    {
        return parent::to_kolab_alarm($value, $event);
    }
}
