<?php

/**
 * Syncroton
 *
 * @package     Syncroton
 * @subpackage  Model
 * @license     http://www.tine20.org/licenses/lgpl.html LGPL Version 3
 * @copyright   Copyright (c) 2012-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 * @author      Lars Kneschke <l.kneschke@metaways.de>
 */

/**
 * class to handle ActiveSync event
 *
 * @package     Syncroton
 * @subpackage  Model
 * @property    string  $class
 * @property    string  $collectionId
 * @property    bool    $deletesAsMoves
 * @property    bool    $getChanges
 * @property    string  $syncKey
 * @property    int     $windowSize
 */
class Syncroton_Model_EventAttendee extends Syncroton_Model_AXMLEntry
{
    protected $_xmlBaseElement = 'Attendee';

    /**
     * attendee status
     */
    public const ATTENDEE_STATUS_UNKNOWN       = 0;
    public const ATTENDEE_STATUS_TENTATIVE     = 2;
    public const ATTENDEE_STATUS_ACCEPTED      = 3;
    public const ATTENDEE_STATUS_DECLINED      = 4;
    public const ATTENDEE_STATUS_NOTRESPONDED  = 5;

    /**
     * attendee types
     */
    public const ATTENDEE_TYPE_REQUIRED = 1;
    public const ATTENDEE_TYPE_OPTIONAL = 2;
    public const ATTENDEE_TYPE_RESOURCE = 3;

    protected $_properties = [
        'Calendar' => [
            'attendeeStatus'          => ['type' => 'number'],
            'attendeeType'            => ['type' => 'number'],
            'email'                   => ['type' => 'string'],
            'name'                    => ['type' => 'string'],
        ],
    ];
}
