<?php

/**
 * Syncroton
 *
 * @package     Syncroton
 * @subpackage  Backend
 * @license     http://www.tine20.org/licenses/lgpl.html LGPL Version 3
 * @copyright   Copyright (c) 2009-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 * @author      Lars Kneschke <l.kneschke@metaways.de>
 */

/**
 * class to handle ActiveSync Sync command
 *
 * @package     Syncroton
 * @subpackage  Backend
 */
interface Syncroton_Backend_IBackend
{
    /**
     * Create a new device
     *
     * @param  Syncroton_Model_IEntry $model
     * @return Syncroton_Model_IEntry
     */
    public function create($model);

    /**
     * Deletes one or more existing devices
     *
     * @param string|Syncroton_Model_IEntry $id
     * @return bool
     */
    public function delete($id);

    /**
     * Return a single device
     *
     * @param string $id
     * @return Syncroton_Model_IEntry
     */
    public function get($id);

    /**
     * Upates an existing persistent record
     *
     * @param  Syncroton_Model_IEntry $model
     * @return Syncroton_Model_IEntry
     */
    public function update($model);
}
