<?php

// URL of kolab-chwala installation
$config['kolab_files_url'] = '/chwala/';

// Optional URL of kolab-chwala installation for connections
// made by the Roundcube host. Useful when the chwala host name does not
// resolve on the server to the same IP as on the client.
// By default kolab_files_url will be used.
$config['kolab_files_server_url'] = '';

// List of files list columns. Available are: name, size, mtime, type
$config['kolab_files_list_cols'] = ['name', 'mtime', 'size'];

// Name of the column to sort files list by
$config['kolab_files_sort_col'] = 'name';

// Order of the files list sort
$config['kolab_files_sort_order'] = 'asc';

// List of editing sessions list columns. Available are: name, owner
$config['kolab_files_sessions_list_cols'] = ['name', 'owner'];

// Name of the column to sort sessions list by
$config['kolab_files_sessions_sort_col'] = 'name';

// Order of the sessions list sort
$config['kolab_files_sessions_sort_order'] = 'asc';

// Number of concurent requests for searching and collections listing. Default: 1
$config['kolab_files_search_threads'] = 1;

// LDAP addressbook that would be searched for user names autocomplete.
// That should be an array refering to the $config['ldap_public'] array key
// or complete addressbook configuration array.
$config['kolab_files_users_source'] = 'kolab_addressbook';

// The LDAP attribute which will be used as ACL user identifier
$config['kolab_files_users_field'] = 'mail';

// The LDAP search filter will be &'d with search queries
$config['kolab_files_users_filter'] = '';
