<?php

class DataTasksTest extends PHPUnit\Framework\TestCase
{
    public static function data_prio()
    {
        return [
            [0, null],
            [1, 2],
            [2, 2],
            [3, 2],
            [4, 2],
            [5, 1],
            [6, 0],
            [7, 0],
            [8, 0],
            [9, 0],
            // invalid input
            [10, null],
        ];
    }

    public static function data_importance()
    {
        return [
            [0, 9],
            [1, 5],
            [2, 1],
            // invalid input
            [null,  null],
            [5, null],
        ];
    }

    /**
     * Test for kolab_sync_data_tasks::prio_to_importance()
     * @dataProvider data_prio()
     */
    public function test_prio_to_importance($input, $output)
    {
        $data   = new kolab_sync_data_tasks_test();
        $result = $data->prio_to_importance($input);

        $this->assertEquals($output, $result);
    }

    /**
     * Test for kolab_sync_data_tasks::importance_to_prio()
     * @dataProvider data_importance()
     */
    public function test_importance_to_prio($input, $output)
    {
        $data   = new kolab_sync_data_tasks_test();
        $result = $data->importance_to_prio($input);

        $this->assertEquals($output, $result);
    }
}

/**
 * kolab_sync_data_tasks wrapper, so we can test preotected methods too
 */
class kolab_sync_data_tasks_test extends kolab_sync_data_tasks
{
    public function __construct()
    {
    }

    public function prio_to_importance($value)
    {
        return parent::prio_to_importance($value);
    }

    public function importance_to_prio($value)
    {
        return parent::importance_to_prio($value);
    }
}
