<?php

/**
 * Syncroton
 *
 * @package     Syncroton
 * @subpackage  Model
 * @license     http://www.tine20.org/licenses/lgpl.html LGPL Version 3
 * @copyright   Copyright (c) 2012-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 * @author      Lars Kneschke <l.kneschke@metaways.de>
 */

/**
 * class to handle MeetingResponse request
 *
 * @package     Syncroton
 * @subpackage  Model
 * @property    int     $userResponse
 * @property    string  $collectionId
 * @property    string  $calendarId
 * @property    string  $requestId
 * @property    string  $instanceId
 * @property    string  $longId
 */
class Syncroton_Model_MeetingResponse extends Syncroton_Model_AXMLEntry
{
    protected $_xmlBaseElement = 'Request';

    /**
     * attendee status
     */
    public const RESPONSE_ACCEPTED  = 1;
    public const RESPONSE_TENTATIVE = 2;
    public const RESPONSE_DECLINED  = 3;

    protected $_properties = [
        'MeetingResponse' => [
            'userResponse'  => ['type' => 'number'],
            'collectionId'  => ['type' => 'string'],
            'calendarId'    => ['type' => 'string'],
            'requestId'     => ['type' => 'string'],
            'instanceId'    => ['type' => 'datetime'],
        ],
        'Search' => [
            'longId'        => ['type' => 'string'],
        ],
    ];
}
