<?php

/**
 * Syncroton
 *
 * @package     Syncroton
 * @subpackage  Backend
 * @license     http://www.tine20.org/licenses/lgpl.html LGPL Version 3
 * @author      Lars Kneschke <l.kneschke@metaways.de>
 * @copyright   Copyright (c) 2009-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */

/**
 * sql backend class for the folder state
 *
 * @package     Syncroton
 * @subpackage  Backend
 */
interface Syncroton_Backend_ISyncState extends Syncroton_Backend_IBackend
{
    /**
     * always returns the latest syncstate
     *
     * @param  Syncroton_Model_IDevice|string  $deviceId
     * @param  Syncroton_Model_IFolder|string  $folderId
     * @return Syncroton_Model_SyncState
     */
    public function getSyncState($deviceId, $folderId);

    public function haveNext($deviceId, $folderId, $syncKey);

    public function resetState($deviceId, $type);

    /**
     * get array of ids which got send to the client for a given class
     *
     * @param Syncroton_Model_IDevice|string $deviceId
     * @param Syncroton_Model_IFolder|string $folderId
     * @param int                            $syncKey
     *
     * @return Syncroton_Model_SyncState|false
     */
    public function validate($deviceId, $folderId, $syncKey);
}
