<?php

/**
 * Kolab Tags backend driver interface
 *
 * @author Aleksander Machniak <machniak@kolabsys.com>
 *
 * Copyright (C) 2024, Apheleia IT AG <contact@apheleia-it.ch>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

namespace KolabTags\Drivers;

interface DriverInterface
{
    /**
     * Tags list
     *
     * @param array $filter Search filter
     *
     * @return array List of tags
     */
    public function list_tags($filter = []);

    /**
     * Create tag object
     *
     * @param array $tag Tag data
     *
     * @return false|array Tag data on success, False on failure
     */
    public function create($tag);

    /**
     * Update tag object
     *
     * @param array $tag Tag data
     *
     * @return false|array Tag data on success, False on failure
     */
    public function update($tag);

    /**
     * Remove tag object
     *
     * @param string $uid Object unique identifier
     *
     * @return bool True on success, False on failure
     */
    public function remove($uid);

    /**
     * Build IMAP SEARCH criteria for mail messages search (per-folder)
     *
     * @param array $tag     Tag data
     * @param array $folders List of folders to search in
     *
     * @return array<string> IMAP SEARCH criteria per-folder
     */
    public function members_search_criteria($tag, $folders);

    /**
     * Returns tag assignments with multiple members
     *
     * @param array<\rcube_message_header> $messages Mail messages
     *
     * @return array<string, array> Tags assigned
     */
    public function members_tags($messages);

    /**
     * Add mail members to a tag
     *
     * @param array $tag      Tag object
     * @param array $messages List of messages in rcmail::get_uids() output format
     *
     * @return bool True on success, False on error
     */
    public function add_tag_members($tag, $messages);

    /**
     * Remove mail members from a tag
     *
     * @param array $tag      Tag object
     * @param array $messages List of messages in rcmail::get_uids() output format
     *
     * @return bool True on success, False on error
     */
    public function remove_tag_members($tag, $messages);
}
