<?php

namespace Tests\Sync\Sync;

class CalendarTest extends \Tests\SyncTestCase
{
    /**
     * Test Sync command
     */
    public function testSync()
    {
        $this->emptyTestFolder($davFolder = 'Calendar', 'event');
        $this->registerDevice();

        // Test empty folder
        $folderId = 'Calendar::Syncroton';
        $syncKey = 0;
        $request = <<<EOF
            <?xml version="1.0" encoding="utf-8"?>
            <!DOCTYPE AirSync PUBLIC "-//AIRSYNC//DTD AirSync//EN" "http://www.microsoft.com/">
            <Sync xmlns="uri:AirSync" xmlns:AirSyncBase="uri:AirSyncBase">
                <Collections>
                    <Collection>
                        <Class>Calendar</Class>
                        <SyncKey>{$syncKey}</SyncKey>
                        <CollectionId>{$folderId}</CollectionId>
                        <DeletesAsMoves/>
                        <GetChanges/>
                    </Collection>
                </Collections>
            </Sync>
            EOF;

        $response = $this->request($request, 'Sync');

        $this->assertEquals(200, $response->getStatusCode());

        $dom = $this->fromWbxml($response->getBody());
        $xpath = $this->xpath($dom);

        $root = "//ns:Sync/ns:Collections/ns:Collection";
        $this->assertSame('1', $xpath->query("{$root}/ns:Status")->item(0)->nodeValue);
        $this->assertSame(strval(++$syncKey), $xpath->query("{$root}/ns:SyncKey")->item(0)->nodeValue);
        $this->assertSame($folderId, $xpath->query("{$root}/ns:CollectionId")->item(0)->nodeValue);
        $this->assertSame(0, $xpath->query("{$root}/ns:Commands/ns:Add")->count());

        if ($this->isStorageDriver('kolab')) {
            $this->markTestSkipped("Appending test objects does not work with 'kolab' storage yet.");
        }

        // Append two event objects and sync them
        $this->appendObject($davFolder, 'event.ics1', 'event');
        $this->appendObject($davFolder, 'event.ics2', 'event');

        $request = str_replace("<SyncKey>0</SyncKey>", "<SyncKey>{$syncKey}</SyncKey>", $request);

        $response = $this->request($request, 'Sync');

        $this->assertEquals(200, $response->getStatusCode());

        $dom = $this->fromWbxml($response->getBody());
        $xpath = $this->xpath($dom);

        $root = "//ns:Sync/ns:Collections/ns:Collection";
        $this->assertSame('1', $xpath->query("{$root}/ns:Status")->item(0)->nodeValue);
        $this->assertSame(strval(++$syncKey), $xpath->query("{$root}/ns:SyncKey")->item(0)->nodeValue);
        $this->assertSame($folderId, $xpath->query("{$root}/ns:CollectionId")->item(0)->nodeValue);
        $this->assertSame(2, $xpath->query("{$root}/ns:Commands/ns:Add")->count());

        $root .= "/ns:Commands/ns:Add";
        $this->assertStringMatchesFormat("CRC%s", $xpath->query("{$root}/ns:ServerId")->item(0)->nodeValue);
        $this->assertSame('20240715T170000Z', $xpath->query("{$root}/ns:ApplicationData/Calendar:StartTime")->item(0)->nodeValue);
        $this->assertSame('Meeting', $xpath->query("{$root}/ns:ApplicationData/Calendar:Subject")->item(0)->nodeValue);
        $this->assertSame('20240714T170000Z', $xpath->query("{$root}/ns:ApplicationData/Calendar:StartTime")->item(1)->nodeValue);
        $this->assertSame('Party', $xpath->query("{$root}/ns:ApplicationData/Calendar:Subject")->item(1)->nodeValue);

        return $syncKey;
    }
}
