<?php

/**
 * Syncroton
 *
 * @package     Syncroton
 * @subpackage  Model
 * @license     http://www.tine20.org/licenses/lgpl.html LGPL Version 3
 * @copyright   Copyright (c) 2012-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 * @author      Lars Kneschke <l.kneschke@metaways.de>
 */

/**
 * class to handle ActiveSync event
 *
 * @package     Syncroton
 * @subpackage  Model
 * @property    string  $class
 * @property    string  $collectionId
 * @property    bool    $deletesAsMoves
 * @property    bool    $getChanges
 * @property    string  $syncKey
 * @property    int     $windowSize
 */
class Syncroton_Model_TaskRecurrence extends Syncroton_Model_AXMLEntry
{
    protected $_xmlBaseElement = 'Recurrence';

    /**
     * recur types
     */
    public const TYPE_DAILY          = 0;     // Recurs daily.
    public const TYPE_WEEKLY         = 1;     // Recurs weekly
    public const TYPE_MONTHLY        = 2;     // Recurs monthly
    public const TYPE_MONTHLY_DAYN   = 3;     // Recurs monthly on the nth day
    public const TYPE_YEARLY         = 5;     // Recurs yearly
    public const TYPE_YEARLY_DAYN    = 6;     // Recurs yearly on the nth day

    /**
     * day of week constants
     */
    public const RECUR_DOW_SUNDAY      = 1;
    public const RECUR_DOW_MONDAY      = 2;
    public const RECUR_DOW_TUESDAY     = 4;
    public const RECUR_DOW_WEDNESDAY   = 8;
    public const RECUR_DOW_THURSDAY    = 16;
    public const RECUR_DOW_FRIDAY      = 32;
    public const RECUR_DOW_SATURDAY    = 64;

    protected $_properties = [
        'Tasks' => [
            'calendarType'            => ['type' => 'number'],
            'dayOfMonth'              => ['type' => 'number'],
            'dayOfWeek'               => ['type' => 'number'],
            'deadOccur'               => ['type' => 'number'],
            'firstDayOfWeek'          => ['type' => 'number'],
            'interval'                => ['type' => 'number'],
            'isLeapMonth'             => ['type' => 'number'],
            'monthOfYear'             => ['type' => 'number'],
            'occurrences'             => ['type' => 'number'],
            'regenerate'              => ['type' => 'number'],
            'start'                   => ['type' => 'datetime'],
            'type'                    => ['type' => 'number'],
            'until'                   => ['type' => 'datetime'],
            'weekOfMonth'             => ['type' => 'number'],
        ],
    ];
}
