<?php

/**
 * Syncroton
 *
 * @package     Syncroton
 * @subpackage  Model
 * @license     http://www.tine20.org/licenses/lgpl.html LGPL Version 3
 * @copyright   Copyright (c) 2012-2014 Kolab Systems AG
 * @author      Aleksander Machniak <machniak@kolabsys.com>
 */

/**
 * class to handle ActiveSync Sync command
 *
 * @package     Syncroton
 * @subpackage  Model
 * @property    string   $acsversion
 * @property    string   $deviceid
 * @property    string   $devicetype
 * @property    string   $friendlyname
 * @property    string   $id
 * @property    string   $imei
 * @property    string   $model
 * @property    string   $os
 * @property    string   $oslanguage
 * @property    string   $ownerId
 * @property    string   $phonenumber
 * @property    string   $pingfolder
 * @property    int      $pinglifetime
 * @property    string   $policykey
 * @property    string   $policyId
 * @property    int      $remotewipe
 * @property    string   $useragent
 * @property    string   $contactsfilter_id
 * @property    string   $calendarfilter_id
 * @property    string   $tasksfilter_id
 * @property    string   $emailfilter_id
 * @property    string   $lastsynccollection
 * @property    DateTime $lastping
 * @property    string   $extraData   JSON-encoded array
 * @property    bool     $isBroken
 *
 * @phpstan-require-extends Syncroton_Model_Device
 */
interface Syncroton_Model_IDevice extends Syncroton_Model_IEntry
{
    /**
     * Returns major firmware version of this device
     *
     * @return int/string
     */
    public function getMajorVersion();
}
