<?php

/**
 * Syncroton
 *
 * @package     Syncroton
 * @subpackage  Model
 * @license     http://www.tine20.org/licenses/lgpl.html LGPL Version 3
 * @copyright   Copyright (c) 2012-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 * @author      Lars Kneschke <l.kneschke@metaways.de>
 */

/**
 * class to handle Email:MeetingRequest
 *
 * @package     Syncroton
 * @subpackage  Model
 * @property    bool     $allDayEvent
 * @property    int      $busyStatus
 * @property    int      $disallowNewTimeProposal
 * @property    DateTime $dtStamp
 * @property    DateTime $endTime
 * @property    string   $globalObjId
 * @property    int      $instanceType
 * @property    int      $meetingMessageType
 * @property    string   $organizer
 * @property    string   $recurrenceId
 * @property    array    $recurrences
 * @property    int      $reminder
 * @property    int      $responseRequested
 * @property    int      $sensitivity
 * @property    DateTime $startTime
 * @property    string   $timezone
 */
class Syncroton_Model_EmailMeetingRequest extends Syncroton_Model_AXMLEntry
{
    /**
     * busy status constants
     */
    public const BUSY_STATUS_FREE      = 0;
    public const BUSY_STATUS_TENATTIVE = 1;
    public const BUSY_STATUS_BUSY      = 2;
    public const BUSY_STATUS_OUT       = 3;

    /**
     * sensitivity constants
     */
    public const SENSITIVITY_NORMAL       = 0;
    public const SENSITIVITY_PERSONAL     = 1;
    public const SENSITIVITY_PRIVATE      = 2;
    public const SENSITIVITY_CONFIDENTIAL = 3;

    /**
     * instanceType constants
     */
    public const TYPE_NORMAL              = 0;
    public const TYPE_RECURRING_MASTER    = 1;
    public const TYPE_RECURRING_SINGLE    = 2;
    public const TYPE_RECURRING_EXCEPTION = 3;

    /**
     * messageType constants
     */
    public const MESSAGE_TYPE_NORMAL      = 0;
    public const MESSAGE_TYPE_REQUEST     = 1;
    public const MESSAGE_TYPE_FULL_UPDATE = 2;
    public const MESSAGE_TYPE_INFO_UPDATE = 3;
    public const MESSAGE_TYPE_OUTDATED    = 4;
    public const MESSAGE_TYPE_COPY        = 5;
    public const MESSAGE_TYPE_DELEGATED   = 6;

    protected $_xmlBaseElement = 'MeetingRequest';

    protected $_properties = [
        'Email' => [
            'allDayEvent'               => ['type' => 'number'],
            'busyStatus'                => ['type' => 'number'],
            'disallowNewTimeProposal'   => ['type' => 'number'],
            'dtStamp'                   => ['type' => 'datetime'],
            'endTime'                   => ['type' => 'datetime'],
            'globalObjId'               => ['type' => 'string'],
            'instanceType'              => ['type' => 'number'],
            'location'                  => ['type' => 'string'],
            'organizer'                 => ['type' => 'string'], //e-mail address
            'recurrenceId'              => ['type' => 'datetime'],
            'recurrences'               => ['type' => 'container'],
            'reminder'                  => ['type' => 'number'],
            'responseRequested'         => ['type' => 'number'],
            'sensitivity'               => ['type' => 'number'],
            'startTime'                 => ['type' => 'datetime'],
            'timeZone'                  => ['type' => 'timezone'],
        ],
        'Email2' => [
            'meetingMessageType'        => ['type' => 'number'],
        ],
    ];
}
