
CREATE TABLE IF NOT EXISTS `kolab_tags` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `color` varchar(8) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `modseq` int UNSIGNED DEFAULT 0,
  PRIMARY KEY(`id`),
  UNIQUE KEY `user_id_name_idx` (`user_id`, `name`),
  INDEX (`updated`),
  CONSTRAINT `fk_kolab_tags_user_id` FOREIGN KEY (`user_id`)
    REFERENCES `users`(`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ROW_FORMAT=DYNAMIC ENGINE=INNODB CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `kolab_tag_members` (
  `tag_id` int UNSIGNED NOT NULL,
  `url` varchar(2048) BINARY NOT NULL,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY(`tag_id`, `url`),
  INDEX (`created`),
  CONSTRAINT `fk_kolab_tag_members_tag_id` FOREIGN KEY (`tag_id`)
    REFERENCES `kolab_tags`(`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ROW_FORMAT=DYNAMIC ENGINE=INNODB CHARACTER SET ascii;

REPLACE INTO `system` (`name`, `value`) VALUES ('kolab-tags-database-version', '2024112000');
