<?php

namespace Tests\Sync\Sync;

class InconsistencyTest extends \Tests\SyncTestCase
{
    /**
     * Test Sync command
     */
    public function testSync()
    {
        $this->emptyTestFolder('INBOX', 'mail');
        $this->registerDevice();

        // Append two mail messages
        $uid1 = $this->appendMail('INBOX', 'mail.sync1');
        $this->appendMail('INBOX', 'mail.sync2');

        // Initial sync
        $folderId = '38b950ebd62cd9a66929c89615d0fc04';
        $syncKey = 0;
        $request = <<<EOF
            <?xml version="1.0" encoding="utf-8"?>
            <!DOCTYPE AirSync PUBLIC "-//AIRSYNC//DTD AirSync//EN" "http://www.microsoft.com/">
            <Sync xmlns="uri:AirSync">
                <Collections>
                    <Collection>
                        <SyncKey>{$syncKey}</SyncKey>
                        <CollectionId>{$folderId}</CollectionId>
                    </Collection>
                </Collections>
            </Sync>
            EOF;

        $response = $this->request($request, 'Sync');
        $this->assertEquals(200, $response->getStatusCode());
        $syncKey++;

        $request = <<<EOF
            <?xml version="1.0" encoding="utf-8"?>
            <!DOCTYPE AirSync PUBLIC "-//AIRSYNC//DTD AirSync//EN" "http://www.microsoft.com/">
            <Sync xmlns="uri:AirSync" xmlns:AirSyncBase="uri:AirSyncBase">
                <Collections>
                    <Collection>
                        <SyncKey>{$syncKey}</SyncKey>
                        <CollectionId>{$folderId}</CollectionId>
                        <DeletesAsMoves>1</DeletesAsMoves>
                        <GetChanges>1</GetChanges>
                        <WindowSize>2</WindowSize>
                        <Options>
                            <FilterType>0</FilterType>
                            <Conflict>1</Conflict>
                            <BodyPreference xmlns="uri:AirSyncBase">
                                <Type>2</Type>
                                <TruncationSize>51200</TruncationSize>
                                <AllOrNone>0</AllOrNone>
                            </BodyPreference>
                        </Options>
                    </Collection>
                </Collections>
            </Sync>
            EOF;

        $response = $this->request($request, 'Sync');

        $this->assertEquals(200, $response->getStatusCode());

        $dom = $this->fromWbxml($response->getBody());
        $xpath = $this->xpath($dom);

        $root = "//ns:Sync/ns:Collections/ns:Collection";
        $this->assertSame('1', $xpath->query("{$root}/ns:Status")->item(0)->nodeValue);
        $this->assertSame(strval(++$syncKey), $xpath->query("{$root}/ns:SyncKey")->item(0)->nodeValue);
        $this->assertSame($folderId, $xpath->query("{$root}/ns:CollectionId")->item(0)->nodeValue);
        $this->assertSame(2, $xpath->query("{$root}/ns:Commands/ns:Add")->count());

        // Initial sync is complete
        // We now artifically create a sync inconsistency be deleting the content part of the first mail.
        // This replicates a situation that we've seen, but don't know yet how it was created in the first place.
        $rcube = \rcube::get_instance();
        $db    = $rcube->get_dbh();
        $result = $db->query(
            "DELETE FROM `syncroton_content`"
            . " WHERE `contentid` = ?",
            "$folderId::$uid1"
        );
        $this->assertNull($db->is_error($result));

        // Now sync again
        $request = <<<EOF
            <?xml version="1.0" encoding="utf-8"?>
            <!DOCTYPE AirSync PUBLIC "-//AIRSYNC//DTD AirSync//EN" "http://www.microsoft.com/">
            <Sync xmlns="uri:AirSync" xmlns:AirSyncBase="uri:AirSyncBase">
                <Collections>
                    <Collection>
                        <SyncKey>{$syncKey}</SyncKey>
                        <CollectionId>{$folderId}</CollectionId>
                        <DeletesAsMoves>1</DeletesAsMoves>
                        <GetChanges>1</GetChanges>
                        <Options>
                            <FilterType>0</FilterType>
                            <Conflict>1</Conflict>
                            <BodyPreference xmlns="uri:AirSyncBase">
                                <Type>2</Type>
                                <TruncationSize>51200</TruncationSize>
                                <AllOrNone>0</AllOrNone>
                            </BodyPreference>
                        </Options>
                    </Collection>
                </Collections>
            </Sync>
            EOF;

        $response = $this->request($request, 'Sync');

        $this->assertEquals(200, $response->getStatusCode());

        $dom = $this->fromWbxml($response->getBody());
        $xpath = $this->xpath($dom);

        $root = "//ns:Sync/ns:Collections/ns:Collection";
        $this->assertSame('1', $xpath->query("{$root}/ns:Status")->item(0)->nodeValue);
        $this->assertSame(strval(++$syncKey), $xpath->query("{$root}/ns:SyncKey")->item(0)->nodeValue);
        $this->assertSame($folderId, $xpath->query("{$root}/ns:CollectionId")->item(0)->nodeValue);
        $this->assertSame(1, $xpath->query("{$root}/ns:Commands/ns:Add")->count());

        // Assert that we have all content parts back
        $result = $db->query(
            "SELECT `contentid` FROM `syncroton_content`"
            . " WHERE `device_id` IN (SELECT `id` FROM `syncroton_device` WHERE `deviceid` = ?)",
            self::$deviceId
        );
        $data = [];
        while ($state = $db->fetch_assoc($result)) {
            $data[] = $state;
        }
        $this->assertSame(2, count($data));

        return $syncKey;
    }
}
