#!/usr/bin/env php
<?php

/*
 +--------------------------------------------------------------------------+
 | Kolab Sync (ActiveSync for Kolab)                                        |
 |                                                                          |
 | Copyright (C) 2024, Apheleia IT AG <contact@apheleia-it.ch>         |
 |                                                                          |
 | This program is free software: you can redistribute it and/or modify     |
 | it under the terms of the GNU Affero General Public License as published |
 | by the Free Software Foundation, either version 3 of the License, or     |
 | (at your option) any later version.                                      |
 |                                                                          |
 | This program is distributed in the hope that it will be useful,          |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of           |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the             |
 | GNU Affero General Public License for more details.                      |
 |                                                                          |
 | You should have received a copy of the GNU Affero General Public License |
 | along with this program. If not, see <http://www.gnu.org/licenses/>      |
 +--------------------------------------------------------------------------+
 | Author: Christian Mollekopf <mollekopf@apheleia-it.ch>                      |
 +--------------------------------------------------------------------------+
*/

require_once 'shared.php';

$opts = rcube_utils::get_opt([
    's' => 'since', // Deletes *all* devices that haven't been used since the given timestamp. Doesn't take owner and device id into account. Timestamp format e.g.: "2024-11-01"
    'o' => 'owner',
    'd' => 'deviceid',
]);

$cli = new SyncrotonCli();
$db = $cli->db;

if (!empty($opts['since'])) {
    $since = $opts['since'];
    $since = new DateTime($since);
    print("Removing all devices that haven't been used since: " . $since->format('Y-m-d H:i:s') . "\n");

    $db->query(
        "DELETE FROM `syncroton_device`"
        . " WHERE `lastping` < ? OR `lastping` = NULL",
        $since->format('Y-m-d H:i:s')
    );
    return;
}

if (empty($opts['deviceid'])) {
    rcube::raise_error("Device id not specified (--deviceid).", false, true);
}

$devices = $cli->selectDevices($opts['deviceid'], null);
if (empty($devices)) {
    rcube::raise_error("Device not found.", false, true);
}

if (empty($opts['owner'])) {
    rcube::raise_error("owner not specified (--owner).", false, true);
}

$userid = $cli->selectUser($opts['owner']);
print("Found the user with id: $userid\n");

foreach ($devices as $device) {
    $db->query(
        "DELETE FROM syncroton_device WHERE owner_id = ? AND id = ?",
        $userid,
        $device
    );
    print("Deleted the device with the deviceid: $device\n");
}
