This is the source code of ActiveSync Service for Kolab.


INTALLATION PROCEDURE
=====================

This package uses [Composer][1] to install and maintain required PHP libraries
as well as the Roundcube framework. The requirements are basically the same as
for Roundcube so please read the INSTALLATION section in the Roundcube
framework's [README][2] file.

1. Install Composer

Execute this in the project root directory:

$ curl -s http://getcomposer.org/installer | php

This will create a file named composer.phar in the project directory.

2. Install Dependencies

$ cp composer.json-dist composer.json
$ php composer.phar install

3. Import the Roundcube Framework (1.2) and Kolab plugins

3.1. Either copy or symlink the Roundcube framework package into lib/ext/Roundcube
3.2. Either copy or symlink the roundcubemail-plugins-kolab into lib/plugins

4. Create database tables structure in the Roundcube database (e.g. using bin/initdb.sh
script from Roundcube). See docs/SQL/.

5. Copy configuration options from config/config.inc.php.dist to Roundcube config file.

6. Give write access for the webserver user to the 'logs' and 'temp' folders:

$ chown <www-user> logs
$ chown <www-user> temp

7. Configure your webserver to point to the root directory of this
package as document root as well as the /Microsoft-Server-ActiveSync alias.
See docs/kolab-syncroton.conf for an example Apache config.


FOR DEVELOPERS (TESTING)
========================

Steps 1-5 from the installation procedure need to be done.

To check code quality run: `vendor/bin/phpstan analyse`

To check code style run: `vendor/bin/php-cs-fixer fix --dry-run --diff --verbose`

To run the Unit test suite goto `tests/` and run `../vendor/bin/phpunit --testsuite=Unit`

To run the integration tests you have to follow these steps:

1. Prepare a test account on the Kolab server and add this to config/config.inc.php:
```
$config['activesync_test_username'] = 'user@domain.tld';
$config['activesync_test_password'] = 'password';
```

   Don't forget to configure also `imap_host`, `activesync_dav_server` and `activesync_storage`.
   All other options should use the default values.

2. Start the syncroton server: `php -S localhost:8000`

3. Goto `tests/` and run `../vendor/bin/phpunit --testsuite=Sync`


[1]: http://getcomposer.org
[2]: https://github.com/roundcube/roundcubemail/blob/master/program/lib/Roundcube/README.md)
